using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        
        Dictionary<long, long> diag1 = new Dictionary<long, long>(); // x+y
        Dictionary<long, long> diag2 = new Dictionary<long, long>(); // x-y

        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split();
            long x = long.Parse(parts[0]);
            long y = long.Parse(parts[1]);

            long d1 = x + y;
            long d2 = x - y;

            if (!diag1.ContainsKey(d1)) diag1[d1] = 0;
            if (!diag2.ContainsKey(d2)) diag2[d2] = 0;

            diag1[d1]++;
            diag2[d2]++;
        }

        long result = 0;

        foreach (var kv in diag1)
        {
            long k = kv.Value;
            result += k * (k - 1);  // svaki par daje 2 susreta
        }
        foreach (var kv in diag2)
        {
            long k = kv.Value;
            result += k * (k - 1);
        }

        Console.WriteLine(result);
    }
}